<?php

function editUser($id)
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $userIndex = (int) $id;
   $prefix = "security.user.[" . $userIndex . "].";

   $security = ParamGet($sock, "security");
   $user = GetUserById((int) $object["id"], $security);

   if ($user == null) {
      socket_close($sock);
      return;
   }

   if (isset($object["password"])) {
      $pass = $object["password"];
      ParamSetString($sock, $prefix . "password", ConvertUTF2Native($pass));
   }

   if (isset($object["accesslevel"])) {
      $level = (int) $object["accesslevel"];
      if ($level == 0) {
         $level += 1;
      }
      if (isset($user->accesslevel)) {
         if ($level * 10 != $user->accesslevel) {
            ParamSetInt($sock, $prefix . "accesslevel", $level * 10);
         }
      } else {
         ParamSetInt($sock, $prefix . "accesslevel", $level * 10);
      }
   }

   if (isset($object["txlimit"])) {
      $txlimit = $object["txlimit"];
      $txlimit = round(($txlimit * 1000000) / 8);

      if (isset($user->txlimit)) {
         if ($txlimit != $user->txlimit) {
            ParamSetInt($sock, $prefix . "txlimit", $txlimit);
         }
      } else {
         ParamSetInt($sock, $prefix . "txlimit", $txlimit);
      }
   }

   if (isset($object["adapters"])) {
      $eth_deny = (int) $object["adapters"];
      if (isset($user->deny->net->adapters)) {
         if ($user->deny->net->adapters != $eth_deny) {
            ParamSetInt($sock, $prefix . "deny.net.adapters", $eth_deny);
         }
      } else {
         ParamSetInt($sock, $prefix . "deny.net.adapters", $eth_deny);
      }
   }

   socket_close($sock);
}
function copyUser($sock, $object, $prefix)
{
   $donor = GetUserByIndex($object["templateUser"], $sock);

   $level = (int) $donor->accesslevel;

   ParamSetInt($sock, $prefix . "accesslevel", $level);

   $limit = isset($donor->txlimit) ? $donor->txlimit : 0;
   ParamSetInt($sock, $prefix . "txlimit", $limit);

   if (!isset($donor->deny)) {
      return;
   }

   $adapter = isset($donor->deny->net->adapters) ? $donor->deny->net->adapters : 0;
   ParamSetInt($sock, $prefix . "deny.net.adapters", $adapter);

   if (isset($donor->deny->misc)) {
      $misc = $donor->deny->misc;
      foreach ($misc as $key => $value) {
         ParamSetInt($sock, $prefix . "deny.misc." . $key, $value);
      }
   }

   if (isset($donor->deny->camera)) {
      $cameras = $donor->deny->camera;
      $index = 0;
      foreach ($cameras as $camera) {
         foreach ($camera as $key => $value) {
            ParamSetInt($sock, $prefix . "deny.camera.[" . $index . "]." . $key, $value);
         }
         $index++;
      }
   }

   if (isset($donor->deny->sound)) {
      $sounds = $donor->deny->sound;
      $index = 0;
      foreach ($sounds as $sound) {
         foreach ($sound as $key => $value) {
            ParamSetInt($sock, $prefix . "deny.sound.[" . $index . "]." . $key, $value);
         }
         $index++;
      }
   }
}
function GetUserByIndex($id, $sock)
{
   $user = null;
   $arr = ParamGet($sock, "security");
   $users = $arr->security->user;

   $key = array_search($id, array_column($users, "id"));
   if ($key !== false) {
      $user = $users[$key];
   }

   return $user;
}
